package parser;

/**
 * Factory for E grammar non-terminal objects.
 */
public class EFact extends ATVFactory {
    /**
     * Factory for E1 grammar non-terminals.
     */
    private E1Fact _e1Fact;

    /**
     * Visitor for E1 grammar non-terminals.
     */
    private ITokVisitor _parseE1;

    /**
     * Initializer lambda for this factory.
     */
    private ILambda _initializer = new ILambda() {
        public Object apply(Object param) {
            // change state to no-op
            _initializer = NoOpLambda.Singleton;

            // initialize
            _parseE1 = _e1Fact.makeVisitor();
            return null;
        }
    };

    /**
     * Constructor for the E factory,
     *
     * @param tkz    tokenizer to use
     * @param e1Fact factory for E1 non-terminals
     */
    public EFact(ITokenizer tkz, E1Fact e1Fact) {
        super(tkz);
        _e1Fact = e1Fact;
    }

    /**
     * Make a token visitor to parse an E non-terminal.
     *
     * @return token visitor
     */
    public ITokVisitor makeVisitor() {
        initialize();
        return new NumToken.INumVisitor() {
            public Object numCase(NumToken host, Object inp) {
                return new E(host, (E1) nextToken().execute(_parseE1, inp));
            }

            public Object defaultCase(AToken host, Object param) {
                throw new IllegalArgumentException("Wrong token: '" + host + "'");
            }
        };
    }

    /**
     * Make a token visitor that delegates to the given visitor in a chain of responsibility
     *
     * @param successor visitor to serve as successor in the chain
     */
    public ITokVisitor makeChainedVisitor(ITokVisitor successor) {
        initialize();
        return new NumToken.AChainVis(successor) {
            public Object numCase(NumToken host, Object inp) {
                return new E(host, (E1) nextToken().execute(_parseE1, inp));
            }
        };
    }

    /**
     * Make the visitor.
     */
    private void initialize() {
        _initializer.apply(null);
    }
}

